## Polyline solution

~~~
import "Apros/Legacy"

connect (ma,ca) (mb,cb) = aconnect ma ca mb cb

addPolyline :: String -> String -> (Double,Double) -> [(Double,Double)] -> <Proc> ()
addPolyline diagram name position xyPoints = ignore $ addRecursively 1 position xyPoints
  where
    addRecursively n position xyPoints | length xyPoints <= 30 = 
        addSmallPolyline n position xyPoints
    addRecursively n (x,y) xyPoints = do
        swPoint = fst (xyPoints!29)
        brName = name + "_BR" + show n
        lvName = name + "_LV" + show n
        swName = name + "_SW" + show n
        aadd diagram "BranchAnalog" brName (x-20, y+5) 
        aadd diagram "LV_CHECKER" lvName (x, y)
        amodi lvName "LVC_LIMIT_VALUE" (fst (xyPoints!29))
        aadd diagram "ANALOG_SWITCH" swName (x+20, y+5)
        (in1, out1) = addSmallPolyline n     (x, y+10) (take 30 xyPoints)
        (in2, out2) = addRecursively   (n+1) (x, y+20) (drop 29 xyPoints)
        connect (brName, "AMUX_OUTPUT_SIGN(1)") (lvName, "LVC_INPUT_SIGN")
        connect (brName, "AMUX_OUTPUT_SIGN(2)") in1       
        connect (brName, "AMUX_OUTPUT_SIGN(4)") in2
        connect (lvName, "LVC_OUTPUT_SIGN_1")   (swName, "SWITCH_CONTROL_S")
        connect out1                            (swName, "SWITCH_INP_SIGN_1")
        connect out2                            (swName, "SWITCH_INP_SIGN_2")
        ((brName, "AMUX_INPUT_SIGN"), (swName, "SWITCH_OUTP_SIGN"))    
    addSmallPolyline n position xyPoints = do
        fullName = name + "_" + show n
        aadd diagram "Polyline" fullName position
        for [1..length xyPoints] $ \i -> do
            (x,y) = xyPoints!(i-1)
            amodi fullName "FUNCTION_X_COORDINATE(\(i))" x
            amodi fullName "FUNCTION_Y_COORDINATE(\(i))" y
            amodi fullName "FUNCTION_OK(\(i))"           True
        ((fullName, "FUNCTION_INPUT_SIGN"), (fullName, "FUNCTION_OUTPUT_SIGN")) 
~~~